/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class GemSetAxe
extends AxeItem {
    private final float baseAttackSpeed;
    private final float baseAttackDamage;

    public GemSetAxe(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.baseAttackSpeed = attackSpeedIn;
        this.baseAttackDamage = attackDamageIn + tier.m_6631_();
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public float getTotalBaseDamage() {
        return this.baseAttackDamage;
    }

    public int getLevelProgress(ItemStack stack) {
        double killCount = 0.0;
        double logCount = 0.0;
        double blockCount = 0.0;
        int killsPerLevel = (Integer)GemsNJewelsConfig.COMMON.axeKillsPerLevel.get();
        int logsPerLevel = (Integer)GemsNJewelsConfig.COMMON.axeLogsPerLevel.get();
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.axeBlocksPerLevel.get();
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Kills") && killsPerLevel > 0) {
                killCount = (double)(nbt.m_128451_("Kills") % killsPerLevel) * (10.0 / (double)killsPerLevel);
            }
            if (nbt.m_128441_("Logs") && logsPerLevel > 0) {
                logCount = (double)(nbt.m_128451_("Logs") % logsPerLevel) * (10.0 / (double)logsPerLevel);
            }
            if (nbt.m_128441_("Blocks") && blocksPerLevel > 0) {
                blockCount = (double)(nbt.m_128451_("Blocks") % blocksPerLevel) * (10.0 / (double)blocksPerLevel);
            }
        }
        return (int)Math.floor(killCount + logCount + blockCount);
    }

    public int getCurrentLevel(ItemStack stack) {
        double killProgress = 0.0;
        double logProgress = 0.0;
        double blockProgress = 0.0;
        int killsPerLevel = (Integer)GemsNJewelsConfig.COMMON.axeKillsPerLevel.get();
        int logsPerLevel = (Integer)GemsNJewelsConfig.COMMON.axeLogsPerLevel.get();
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.axeBlocksPerLevel.get();
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Kills") && killsPerLevel > 0) {
                killProgress = (double)nbt.m_128451_("Kills") / (double)killsPerLevel;
            }
            if (nbt.m_128441_("Logs") && logsPerLevel > 0) {
                logProgress = (double)nbt.m_128451_("Logs") / (double)logsPerLevel;
            }
            if (nbt.m_128441_("Blocks") && blocksPerLevel > 0) {
                blockProgress = (double)nbt.m_128451_("Blocks") / (double)blocksPerLevel;
            }
        }
        return (int)(killProgress + logProgress + blockProgress);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.m_6084_()) {
            CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
            if (nbt.m_128441_("Kills")) {
                nbt.m_128405_("Kills", nbt.m_128451_("Kills") + 1);
            } else {
                nbt.m_128405_("Kills", 1);
            }
            stack.m_41751_(nbt);
        }
        int level = this.getCurrentLevel(stack);
        if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int randomChance = attacker.f_19853_.f_46441_.nextInt(2);
            if (level >= 7 && randomChance == 1) {
                return true;
            }
        }
        stack.m_41622_(2, attacker, p_220039_0_ -> p_220039_0_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean isNamedLog;
        CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
        String displayName = new ItemStack((ItemLike)worldIn.m_8055_(pos).m_60734_()).m_41611_().getString();
        boolean bl = isNamedLog = displayName.equals("log") || displayName.length() > 3 && (displayName.toLowerCase().substring(displayName.length() - 4).equals(" log") || displayName.toLowerCase().contains(" log "));
        if (isNamedLog) {
            if (nbt.m_128441_("Logs")) {
                nbt.m_128405_("Logs", nbt.m_128451_("Logs") + 1);
            } else {
                nbt.m_128405_("Logs", 1);
            }
            stack.m_41751_(nbt);
        } else {
            if (nbt.m_128441_("Blocks")) {
                nbt.m_128405_("Blocks", nbt.m_128451_("Blocks") + 1);
            } else {
                nbt.m_128405_("Blocks", 1);
            }
            stack.m_41751_(nbt);
        }
        if (stack.m_41782_() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int level = this.getCurrentLevel(stack);
            int randomChance = entityLiving.f_19853_.f_46441_.nextInt(2);
            if (level >= 7 && randomChance == 1) {
                return true;
            }
            if (level >= 3 && !entityLiving.f_19853_.m_5776_()) {
                int j;
                for (int i = entityLiving.f_19853_.f_46441_.nextInt(2) + entityLiving.f_19853_.f_46441_.nextInt(2); i > 0; i -= j) {
                    j = ExperienceOrb.m_20782_((int)i);
                    entityLiving.f_19853_.m_7967_((Entity)new ExperienceOrb(entityLiving.f_19853_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), j));
                }
            }
        }
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlot.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int lvl = this.getCurrentLevel(stack);
        attackSpeedBonus = attackSpeedBonus * (float)lvl / 40.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.baseAttackDamage, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = super.m_6225_(context);
        if (result.equals((Object)InteractionResult.SUCCESS) || result.equals((Object)InteractionResult.CONSUME)) {
            ItemStack stack = context.m_43722_();
            CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
            if (nbt.m_128441_("Blocks")) {
                nbt.m_128405_("Blocks", nbt.m_128451_("Blocks") + 1);
            } else {
                nbt.m_128405_("Blocks", 1);
            }
            stack.m_41751_(nbt);
        }
        return result;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Logs") || stack.m_41783_().m_128441_("Blocks") || stack.m_41783_().m_128441_("Kills")) {
            int i;
            int killCount = stack.m_41783_().m_128451_("Kills");
            String kills = "\u00a7e" + Integer.toString(killCount);
            if (killCount > 0) {
                TextComponent slain = new TextComponent("Mobs Slain: " + kills);
                tooltip.add((Component)slain);
            }
            int logCount = stack.m_41783_().m_128451_("Logs");
            String logs = "\u00a7e" + Integer.toString(logCount);
            if (logCount > 0) {
                TextComponent mined = new TextComponent("Logs Chopped: " + logs);
                tooltip.add((Component)mined);
            }
            int lvlProgress = this.getLevelProgress(stack);
            int lvl = this.getCurrentLevel(stack);
            String level = "Lvl: " + lvl;
            level = lvl < 5 ? level + " \u00a77Novice" : (lvl < 10 ? level + " \u00a7aAdept" : (lvl < 20 ? level + " \u00a7bHeroic" : (lvl < 30 ? level + " \u00a7dMaster" : (lvl < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            Object progression = "|\u00a7a";
            for (i = 0; i < lvlProgress % 10; ++i) {
                progression = (String)progression + "=";
            }
            progression = (String)progression + "\u00a77";
            for (i = lvlProgress % 10; i < 10; ++i) {
                progression = (String)progression + "-";
            }
            progression = (String)progression + "\u00a7f|";
            TextComponent levelText = new TextComponent(level);
            TextComponent progText = new TextComponent((String)progression);
            tooltip.add((Component)levelText);
            tooltip.add((Component)progText);
            tooltip.add((Component)new TextComponent("\u00a75-Gains bonus swing speed per level"));
            if (lvl >= 3) {
                tooltip.add((Component)new TextComponent("\u00a75-Chopping blocks grants experience"));
            }
            if (lvl >= 7) {
                tooltip.add((Component)new TextComponent("\u00a75-Resists tool damage"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent("\u00a77Gains perks from chopping blocks or slaying mobs"));
        }
    }
}

